local assets=
{ 
    Asset("ANIM", "anim/chaosblade.zip"),
    Asset("ANIM", "anim/chaosblade_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/chaosblade.xml"),
    
}

local prefabs = 
{
}
local newdmgmult



local function OnAttack(inst, attacker, target)	
	if attacker and attacker.components.sanity then
		attacker.components.sanity:DoDelta(1)
	end
	if attacker and attacker.components.health then
		attacker.components.health:DoDelta(-3)
	end
end

local function StatBoost(inst, data)
    local percent = inst.components.health:GetPercent()
    inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier - newdmgmult --very first time it is the character dmgmult. without anything it is 0.9
    if (percent < 0.25) then
        newdmgmult = 0.60
    elseif (percent < 0.40) then
        newdmgmult = 0.35
    elseif (percent < 0.50) then
        newdmgmult = 0.20
    elseif (percent < 0.75) then -- Less than 75%
        newdmgmult = 0.10
    else 
        newdmgmult = 0.00
    end
    inst.components.combat.damagemultiplier = inst.components.combat.damagemultiplier + newdmgmult --if it was >0.95 then now dmgmult=0.9+0.00
end

local function fn(colour)

    local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "chaosblade_swap", "chaosblade_swap")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
        newdmgmult=0;
        owner:ListenForEvent("hungerdelta", StatBoost)

    end

    local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
		owner:RemoveEventCallback("hungerdelta", StatBoost)
		owner.components.combat.damagemultiplier = owner.components.combat.damagemultiplier - newdmgmult
    end
	
	local function onfinished(inst)
		inst:Remove()
	end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("chaosblade")
    anim:SetBuild("chaosblade")
    anim:PlayAnimation("idle")

    inst:AddComponent("inventoryitem")
	--(DST)inst.components.inventoryitem.keepondeath = true
    inst.components.inventoryitem.imagename = "chaosblade"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/chaosblade.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	--(DST)inst.components.inventoryitem.keepondeath = true
	
	inst:AddComponent("inspectable")
	
	inst:AddTag("sword")
	inst:AddTag("blade")
	
	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(90)
	inst.components.weapon:SetRange(0.15, 0.15)
	inst.components.weapon:SetOnAttack(OnAttack)
	

	inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150) 
    inst.components.finiteuses:SetOnFinished( onfinished )
	
    return inst
end

return  Prefab("common/inventory/chaosblade", fn, assets, prefabs)